/**
 * Base class to setup properties and common extensions for domain specific errors.
 */
export class ErrorBase<T extends string> extends Error {
    name: T;
    message: string;
    cause: unknown;

    constructor({
        name,
        message,
        cause
    }: {
        name: T;
        message: string;
        cause?: unknown;
    }) {
        super();
        this.name = name
        this.message = message
        this.cause = cause
    }
}